'use strict'

entityRegistry['module']['brightWarp'] = {
    extendedInfo: {
        displayName: 'Bright Warp',
        displayGroup: 'Post Processing',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'size', displayName: 'Size', type: 'float', defaultValue: 0.1},
        { paramName: 'strength', displayName: 'Strength', type: 'float', defaultValue: 0.1},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                size,
                strength,
            } = { ...config }

            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const brightnessBufferData = brightnessBuffer.data

            for (let y = 0; y < brightnessBuffer.height; ++y) {
                let index = y * brightnessBuffer.width + 3
                const mod = Math.sin(y*size)*strength
                for (let x = 0; x < brightnessBuffer.width; ++x) {
                    brightnessBufferData[index] += mod
                    index++
                }
            }
        }
    }
}
